<?xml version="1.0" encoding="UTF-8"?>
<!-- 
    Generic stylesheet to show the content of electronically signed documents.
    
    Copyright 2008 Nictiz
    
    author: Marc de Graauw
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ao="http://www.aortarelease.nl/805/" xmlns:hl7="urn:hl7-org:v3" version="1.0">
    <xsl:output method="html" encoding="UTF-8"/>
    <xsl:template match="/">
        <html>
            <head/>
            <body>
                <xsl:for-each select="//ao:signatureTokens/ao:signedData/ao:meal">
                <h1>
                    Maaltijd <xsl:value-of select="ao:id/ao:extension"/>
                </h1>
                    <table border="1">
                    <tr><td>Maaltijdnummer:</td><td><xsl:value-of select="ao:id/ao:extension"/></td></tr>
                    <tr><td>Tijdstip maaltijdvoorschrift:</td><td><xsl:value-of select="substring(ao:dateTime,7,2)"/>-<xsl:value-of select="substring(ao:dateTime,5,2)"/>-<xsl:value-of select="substring(ao:dateTime,1,4)"/>, <xsl:value-of select="substring(ao:dateTime,9,2)"/>:<xsl:value-of select="substring(ao:dateTime,11,2)"/></td></tr>
                    <tr><td></td><td></td></tr>
                    <tr><td>Patient:</td><td><xsl:value-of select="ao:patient/ao:name"/></td></tr>
                    <tr><td>Geslacht:</td><td><xsl:value-of select="ao:patient/ao:gender"/></td></tr>
                    <tr><td>Geboortedatum:</td><td><xsl:value-of select="substring(ao:patient/ao:birthdate,7,2)"/>-<xsl:value-of select="substring(ao:patient/ao:birthdate,5,2)"/>-<xsl:value-of select="substring(ao:patient/ao:birthdate,1,4)"/></td></tr>
                    <tr><td>BSN:</td><td><xsl:value-of select="ao:patient/ao:id/ao:extension"/></td></tr>
                    <tr><td></td><td></td></tr>
                    <tr><td>Voorschrift van:</td><td><xsl:value-of select="ao:author/ao:name"/></td></tr>
                    <tr><td>UZI-nummer:</td><td><xsl:value-of select="ao:author/ao:id"/></td></tr>
                    <tr><td></td><td></td></tr>
                    <tr><td>Gerecht:</td><td><xsl:value-of select="ao:dinner/ao:text"/></td></tr>
                    <tr><td>Gebruik:</td><td><xsl:value-of select="ao:usage"/></td></tr>
                </table>
                </xsl:for-each>
            </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
